#!/usr/bin/env python

import sys
import subprocess
import re

Metrics = ["ACH","AC","PC","PEERS","ACP","ICP","VR","STT","LRT","DLPDSA","DLPUSB","PKDCL","QC","HLDT","TLKT","QCALLS","QACALLS"]

# Descricao das Opcoes
# "ACH" - Canais ativos
# "AC" - Licacoes ativas
# "PC" - Licacoes processadas
# "PEERS" - Peers
# "ACP" - Peers ativos
# "ICP" - Peers inativos
# "VR" - Versao
# "STT" - Startup time
# "DLPDSA" - Dundi DSA
# "PKDCL" - Parked Calls
# "QC" - Queued calls
# "HLDT" - Queue Tempo de espera
# "TLKT" - Queue Tempo de fala
# "QCALLS" - Queue Chamadas
# "QACALLS" - Queue Chamadas Abandonadas

from subprocess import PIPE, Popen

def cmdline(command):
    process = Popen(
        args=command,
        stdout=PIPE,
        shell=True
    )
    return process.communicate()[0]


def get_metric(metric):
    if metric == "ACH":
	command = cmdline("sudo asterisk -rx 'sip show channels'")
	active_calls = (len(command.split('\n')))-2
	return active_calls
    elif metric == "AC":
        command = cmdline("sudo asterisk -rx 'core show calls' | grep 'active call'")
        active_calls = [int(s) for s in command.split() if s.isdigit()]
	return active_calls[0]
    elif metric == "PC":
        command = cmdline("sudo asterisk -rx 'core show calls' | grep 'calls processed'")
        calls_processed = [int(s) for s in command.split() if s.isdigit()]
        return calls_processed[0]
    elif metric == "PEERS":
	command = cmdline("sudo asterisk -rx 'sip show peers'")
	peers = len((command.split('\n')))-3
        return peers
    elif metric == "ACP":
        command = cmdline("sudo asterisk -rx 'sip show peers'")
        active_peers = command.count("OK")
        return active_peers
    elif metric == "ICP":
        command = cmdline("sudo asterisk -rx 'sip show peers'")
        inactive_peers = command.count("UNKNOWN")
        return inactive_peers
    elif metric == "VR":
        command = cmdline("sudo asterisk -rx 'core show settings' | grep 'Version:'")
        version = command.split()
        return version[1]
    elif metric == "STT":
        command = cmdline("sudo asterisk -rx 'core show settings' | grep 'Startup time:'")
        stt = command.split()
        return stt[2]
    elif metric == "LRT":
        command = cmdline("sudo asterisk -rx 'core show settings' | grep 'Last reload time:'")
        lrt = command.split()
        return lrt[1]
    elif metric == "DLPDSA":
        command = cmdline("sudo asterisk -rx 'dundi lookup 0201000@priv' | grep 'DUNDi lookup returned no results.'")
        if command == "DUNDi lookup returned no results.":
		dundi_dsa= 0
	else:
		dundi_dsa = 1
        return dundi_dsa
    elif metric == "DLPUSB":
        command = cmdline("sudo asterisk -rx 'dundi lookup 0701600@priv' | grep 'DUNDi lookup returned no results.'")
        if command == "DUNDi lookup returned no results.":
                dundi_usb= 0
        else:
                dundi_usb = 1
        return dundi_usb
    elif metric == "PKDCL":
        command = cmdline("sudo asterisk -rx 'parkedcalls show' | grep 'parked calls in total'")
        pkdcl = command.split()
        return pkdcl[0]
    elif metric == "QC":
	command = cmdline("sudo asterisk -rx 'queue show' | grep '[0-9] has [0-9] calls'")
	qc = command.split()
	return qc[2]
    elif metric == "HLDT":
        command = cmdline("sudo asterisk -rx 'queue show' | grep '[0-9] has [0-9] calls'")
	a = command.split()
        hldt = a[9]
	hldt = hldt.replace("(","")
	hldt = hldt.replace("s","")
        return hldt
    elif metric == "TLKT":
        command = cmdline("sudo asterisk -rx 'queue show' | grep '[0-9] has [0-9] calls'")
        a = command.split()
	tlkt = a[11]
	tlkt = tlkt.replace("s","")
        return tlkt
    elif metric == "QCALLS":
        command = cmdline("sudo asterisk -rx 'queue show' | grep '[0-9] has [0-9] calls'")
        a = command.split()
        qcalls = a[14]
	qcalls = qcalls.replace("C:","")
	qcalls = qcalls.replace(",","")
        return qcalls
    elif metric == "QACALLS":
        command = cmdline("sudo asterisk -rx 'queue show' | grep '[0-9] has [0-9] calls'")
        a = command.split()
        qcalls = a[15]
        qcalls = qcalls.replace("A:","")
        qcalls = qcalls.replace(",","")
        return qcalls




if __name__ == "__main__":
    try:
        metric = sys.argv[1]
        if metric not in Metrics:
            print("Opcao Invalida")
            sys.exit(1)
        else:
            print (get_metric(metric))
    except:
        print("Dados nao disponiveis")
