# zabbix

### Instalação zabbix no asterisk


> Baixar e instalar arquivo zabbix agent conforme sistema operacional 
```
wget https://git.usb.org.br/infra/zabbix/raw/master/zabbix_v2/Centos%206/agent2/zabbix-agent2-7.0.0-release1.el6.x86_64.rpm -P /zabbix_files
yum -y install /zabbix_files/zabbix-agent2-7.0.0-release1.el6.x86_64.rpm
```



> em "/etc/zabbix/zabbix_agent2.conf" 
```
Altere DebugLevel=3
Server=<PROXY_IP>
Hostname=<HOST_NAME>
UserParameter=asterisk[*],/etc/zabbix/asterisk.py \$1
```


* Comentar linha -> ServerActive=127.0.0.1 
* copiar script asterisk.py para /etc/zabbix 
* chmod +x /etc/zabbix/asterisk.py

### Adicionar usuário zabbix ao /etc/asterisk/manager_custom.conf 
```
[zabbix]
secret = <SUA_SENHA>
deny=0.0.0.0/0.0.0.0
permit=<IP_PROXY>/255.255.255.255
read = all
write = all
```



### No painel freepbx: Setting -> Advanced Settings
> "Asterisk Builtin mini-HTTP server" mudar para True <br/>
> "Enable Static Content" mudar para True




### Em "/etc/asterisk/http_additional.conf" Habilite o suporte para http do asterisk deixando a configuração da seguinte maneira

```
[general]
enabled=yes
enablestatic=yes
bindaddr=0.0.0.0
bindport=8088
prefix=
```



### Adicionar exceção ao iptables

```
### ZABBIX MONITORING
-A INPUT -s 10.0.0.0/8 -p tcp -m state -m tcp --dport 10050:10053 --state NEW -j ACCEPT

### AMI ASTERISK ZABBIX MONITORING
-A INPUT -s 10.11.0.0/22 -p tcp -m state --state NEW -m tcp --dport 5038 -j ACCEPT
-A INPUT -s 10.11.0.0/22 -p tcp -m state --state NEW -m tcp --dport 8088 -j ACCEPT

```

### Adicionar Permissão ao usuário para asterisk

```
echo "zabbix ALL=(ALL) NOPASSWD:ALL" >> /etc/sudoers
```

### Reiniciar o asterisk
```
service asterisk restart
systemctl restart asterisk
```

### Dentro do zabbix > Data Collection > Hosts > VOIP
> Adicionar templates
> Asterisk by HTTP
> Linux by Zabbix agent
> Template Asterisk
> Adicionar IP do voip


### Iniciar aplicação
```
service zabbix-agent2 start
chkconfig zabbix-agent2 on
```
