#!/usr/bin/env python3
import subprocess
import time

# Link 1
IF_LINK1 = "eth2"
MASK_LINK1 = None
IP_LINK1 = None
GW_LINK1 = None
NT_LINK1 = None

# Link 2
IF_LINK2 = "eth3"
MASK_LINK2 = None
IP_LINK2 = None
GW_LINK2 = None
NT_LINK2 = None

def obter_informacoes_rede(interface_param):
    ip_cidr = subprocess.check_output(["nmcli", "-g", "IP4.ADDRESS", "dev", "show", interface_param], text=True).strip()
    ip_address = ip_cidr.split('/')[0]
    subnet_mask = ip_cidr.split('/')[1]
    gateway = subprocess.check_output(["nmcli", "-g", "IP4.GATEWAY", "dev", "show", interface_param], text=True).strip()
    network_address = subprocess.check_output(["ipcalc", "-n", "-b", "-n", "-s", "-b", ip_cidr], text=True).split('\n')[1].split()[1]
    return ip_address, subnet_mask, gateway, network_address

def up_link1_default(gw_link1, gw_link2):
    print(f"fail-over: Alterando para a rota padrão via {gw_link1}")
    subprocess.run(["ip", "route", "del", "default", "via", gw_link2])
    subprocess.run(["ip", "route", "add", "default", "via", gw_link1])

def up_link2_default(gw_link1, gw_link2):
    print(f"fail-over: Alterando para a rota padrão via {gw_link2}")
    subprocess.run(["ip", "route", "del", "default", "via", gw_link1])
    subprocess.run(["ip", "route", "add", "default", "via", gw_link2])

def check_link(if_link, gw_link1, gw_link2):
    while True:
        try:
            subprocess.run(["ping", "-c", "1", "-I", if_link, "9.9.9.9"], check=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
            if not subprocess.run(["ip", "route", "show", "default"], stdout=subprocess.PIPE, stderr=subprocess.PIPE).stdout.decode().count(f"via {gw_link1}"):
                up_link1_default(gw_link1, gw_link2)
        except subprocess.CalledProcessError:
            if subprocess.run(["ip", "route", "show", "default"], stdout=subprocess.PIPE, stderr=subprocess.PIPE).stdout.decode().count(f"via {gw_link1}"):
                up_link2_default(gw_link1, gw_link2)
        time.sleep(15)

def main():
    global MASK_LINK1, IP_LINK1, GW_LINK1, NT_LINK1, MASK_LINK2, IP_LINK2, GW_LINK2, NT_LINK2

    print("fail-over: Iniciando Servico")

    # Link 1
    resultado = obter_informacoes_rede(IF_LINK1)
    IP_LINK1, MASK_LINK1, GW_LINK1, NT_LINK1 = resultado

    # Link 2
    resultado = obter_informacoes_rede(IF_LINK2)
    IP_LINK2, MASK_LINK2, GW_LINK2, NT_LINK2 = resultado

    # Definindo rotas link principal
    subprocess.run(["ip", "route", "add", f"{NT_LINK1}/{MASK_LINK1}", "dev", IF_LINK1])
    subprocess.run(["ip", "route", "add", f"{NT_LINK1}/{MASK_LINK1}", "dev", IF_LINK1, "table", "T1"])
    subprocess.run(["ip", "route", "add", "default", "via", GW_LINK1, "table", "T1"])

    # Definindo rotas link Secundario
    subprocess.run(["ip", "route", "add", f"{NT_LINK2}/{MASK_LINK2}", "dev", IF_LINK2])
    subprocess.run(["ip", "route", "add", f"{NT_LINK2}/{MASK_LINK2}", "dev", IF_LINK2, "table", "T2"])
    subprocess.run(["ip", "route", "add", "default", "via", GW_LINK2, "table", "T2"])

    # Validando se link dedicado esta ativo e fazendo failover
    subprocess.run(["ip", "route", "add", "9.9.9.9", "via", GW_LINK1])
    subprocess.run(["ip", "route", "add", "149.112.112.112", "via", GW_LINK2])

    # Criando novos encaminhamentos das tabelas
    subprocess.run(["ip", "rule", "add", "from", IP_LINK1, "table", "T1"])
    subprocess.run(["ip", "rule", "add", "from", IP_LINK2, "table", "T2"])

    # Marca pacotes para sairem pelo link2
    subprocess.run(["ip", "rule", "add", "fwmark", "2", "table", "T2"])

    # verifica o link e definindo rota default
    check_link(IF_LINK1, GW_LINK1, GW_LINK2)

if __name__ == "__main__":
    main()
