import psutil
import netifaces
import logging
import socket

logger = logging.getLogger(__name__)

class FailoverModel:
    def get_failover_data(self):
        try:
            interfaces = self._get_interfaces_data()
            return {"mensagem": "Página de Failover", "interfaces": interfaces}
        except Exception as e:
            logger.exception("Erro ao obter dados de failover: %s", str(e))
            return {"mensagem": "Erro ao obter dados de failover", "interfaces": []}

    def _get_interfaces_data(self):
        result = []
        gateways = netifaces.gateways()
        for interface, addrs in psutil.net_if_addrs().items():
            for addr in addrs:
                if addr.family == socket.AF_INET and interface.startswith('eth'):
                    gateway_info = gateways.get('default', {}).get(netifaces.AF_INET, [])
                    gateway_address = gateway_info[0] if gateway_info else 'Gateway não encontrado'
                    interface_info = {
                        'INTERFACE_NAME': interface,
                        'IP': addr.address,
                        'MASK': addr.netmask,
                        'GATEWAY': gateway_address,
                    }
                    result.append(interface_info)
        return result
