#!/bin/bash
#Instalação do UNIFI 7.3.83
####################################################################################
#Variaveis de instalação
RED='\033[0;31m'
NC='\033[0m' # No Color

####################################################################################
disable_selinux(){
        sed -i /etc/selinux/config -r -e 's/^SELINUX=.*/SELINUX=disabled/g'
}
install_components(){
        #yum -q -y install epel-release java-1.8.0-openjdk unzip wget
        yum -q -y install java-11-openjdk-devel epel-release unzip wget
}
configure_mongorepo(){
        cat >/etc/yum.repos.d/mongodb-org-5.0.repo<<EOF
[mongodb-org-5.0]
name=MongoDB Repository
baseurl=https://repo.mongodb.org/yum/redhat/7/mongodb-org/5.0/x86_64/
gpgcheck=1
enabled=1
gpgkey=https://www.mongodb.org/static/pgp/server-5.0.asc
EOF
}
install_mongo(){
        yum install -q -y mongodb-org
}
creating_user(){
        adduser -r -s /bin/nologin ubnt
}
install_unifi(){
        wget https://dl.ui.com/unifi/7.3.83/UniFi.unix.zip -P /opt -q
        unzip -qq /opt/UniFi.unix.zip -d /opt
        chown -R ubnt:ubnt /opt/UniFi
        rm -rf /opt/UniFi.unix.zip
}
creating_service_unifi(){
        cat >/etc/systemd/system/unifi.service<<EOF
#
# Systemd unit file for UniFi Controller
#

[Unit]
Description=UniFi AP Web Controller
After=syslog.target network.target

[Service]
Type=simple
User=ubnt
WorkingDirectory=/opt/UniFi
ExecStart=/usr/bin/java -Xmx1024M -jar /opt/UniFi/lib/ace.jar start
ExecStop=/usr/bin/java -jar /opt/UniFi/lib/ace.jar stop
SuccessExitStatus=143


[Install]
WantedBy=multi-user.target
EOF
}
starting_service_unifi(){
        systemctl enable unifi.service --quiet
        systemctl start unifi.service --quiet
}
stty echo
echo -e "${RED}Iniciando Instalação${NC}"
echo -e "${RED}Desabilitando SE Linux${NC}"
disable_selinux
echo -e "${RED}Instalando Componentes${NC}"
install_components
configure_mongorepo
echo -e "${RED}Instalando MongoDB${NC}"
install_mongo
echo -e "${RED}Criando Usuário${NC}"
creating_user
echo -e "${RED}Instalando UniFi${NC}"
install_unifi
echo -e "${RED}Configurando serviço${NC}"
creating_service_unifi
echo -e "${RED}Iniciando Unifi${NC}"
starting_service_unifi
echo -e "${RED}Instalação Concluida${NC}"
