<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Client;

class TokenValidationMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $token = $request->header('Authorization');

        $token = str_replace('Bearer ', '', $token);

        if (empty($token)) {
            return response()->json(['error' => 'Token não fornecido'], 401);
        }

        try {

            $url = env('API_AUTH_URL');

            // Faça a chamada à API de autenticação para verificar o token
            $response = $this->verifyToken($url, $token);

            if ($response->getStatusCode() !== 200) {
                return response()->json(['error' => 'Invalid token'], 401);
            }
        } catch (RequestException $e) {
            if ($e->getResponse()->getStatusCode() === 401) {
                return response()->json(['error' => 'Invalid token'], 401);
            }

            // Outros tratamentos de erro, se necessário
        }

        $body       = $response->getBody()->getContents();
        $data       = json_decode($body, true);
        $accountId  = $data['body']['users_id'];
        $sistema    = $data['body']['sistema'];
        $sistemaweb = env('TOKEN_SISTEMA');

        if($sistema != $sistemaweb){
            return response()->json(['error' => 'Invalid token'], 401);
        }

        $request->attributes->add(['accountId' => $accountId]);

        return $next($request);
    }

    private function verifyToken($url, $token)
    {

        $client = new Client();
        $response = $client->get($url, [
            'headers' => [
                'Authorization' => $token,
            ],
        ]);

        return $response;
    }
}
