<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Helpers\Helpers;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;

class PerfilController extends Controller
{
    //
    function perfil(Request $request){
        try{

            $idUser = $request->get('accountId');

            $perfilDb = DB::select("select p.id, p.nome, p.telefone, u.Email email, p.funcao_id, f.descricao, p.entidade_id, e.Name nome_entidade, case when u.photo is not null then concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',u.photo) else null end foto, u.photo nome_foto, u.hash from pessoas p
                                            inner join funcoes f on f.id = p.funcao_id
                                            inner join ERPUSB..Entity e on e.Entityid = p.entidade_id
                                            inner join ERPUSB..Users u on u.UsersId = p.usuario_id
                                            LEFT JOIN globais g on g.id = 1 
                                            where p.usuario_id = ?",[$idUser]);

            foreach ($perfilDb as $perfil) {
                    if ($perfil->hash != null) {
                            $apiResp = $this->buscaImgApiERPUSB($perfil->hash);
                                
                            if(!empty($apiResp)){
                                $perfil->foto = $apiResp['body']['url'];
                                $perfil->nome_foto = $apiResp['body']['name'];
                            }
                    }
            }                                

            $tipo = [
                        "id" => "intVal",
                        "funcao_id" => "intVal",
                        "entidade_id" => "intVal",
            ];
                                                        
            $resposta = Helpers::convertTypes($perfilDb, $tipo);

            return Helpers::successResponse($resposta[0]);

        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function AlteraPerfil(Request $request){
        try{

            $content = $request->getContent();
            $data = json_decode($content, true);
            

            $idUser = $request->get('accountId');

            $validacao = Validator::make($data,[
                'nome'     => 'required',
                'telefone' => 'required',
            ],
        [
                'nome'     => 'Informe um nome',
                'telefone' => 'Informe um telefone',
            ]);

            if($validacao->fails()){
                return Helpers::errorResponse($validacao->errors(), 500);
            }

            DB::update('update p set p.telefone = ?, p.nome = ? from pessoas p
                                where p.usuario_id = ?   ',[$data['telefone'], $data['nome'], $idUser]);

            DB::update('update p set p.Name = ? from ERPUSB..Users p
                                where p.UsersId = ?   ',[$data['nome'], $idUser]);

            return Helpers::successResponse('Alteração Realizado Com Sucesso.');
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function buscaImgApi($token){
        try{
            $resposta = Http::get(env('URL_API_PHOTO') . '/'. env('TOKEN_V_API_PHOTO') . '/' . $token);
            if($resposta->successful()){
                $data = $resposta->json();
            } else {
                $data = [];
            }
                
            return $data;
        } catch (\Exception $e) {
            
        }
    }

    function buscaImgApiERPUSB($token){
        try{
            $resposta = Http::get(env('URL_API_PHOTO') . '/'. env('TOKEN_V_API_PHOTO_ERPUSB') . '/' . $token);
            if($resposta->successful()){
                $data = $resposta->json();
            } else {
                $data = [];
            }
                
            return $data;
        } catch (\Exception $e) {
            
        }
    }

}
