<?php

namespace App\Http\Controllers;

use App\Helpers\Helpers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class NotificacoesController extends Controller
{
    //
    function notificacoes(Request $request, $idEvento = 0){
        try{

            $idUser = $request->get('accountId');

            $notificacaoResp = DB::select("select a.id, a.evento_id, a.palestra_id, pa.titulo, a.descricao, a.created_at, a.pessoa_id, p.nome, case when u.photo is not null then concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',u.photo) else null end photo, u.photo foto_nome, u.UsersId foto_user_id, f.descricao funcao from anuncios a
            left join pessoas p on p.id = a.pessoa_id
            left join ERPUSB..Users u on u.UsersId = p.usuario_id
            left join funcoes f on f.id = a.funcao_id
            left JOIN palestras pa on pa.id = a.palestra_id
            LEFT JOIN globais g on g.id = 1 
            where a.evento_id in(
                select evento_id from inscricoes ii 
                inner join pessoas pp on pp.id = ii.pessoa_id
                where pp.usuario_id = ? and (ii.evento_id = ? or ? = 0)
            ) order by created_at desc", [$idUser, $idEvento, $idEvento]);

            $tipo = [
                "id" => "intVal",
                "evento_id" => "intVal",
                "palestra_id" => "intVal",
                "pessoa_id" => "intVal",
            ];
                                                                        
            $resposta = Helpers::convertTypes($notificacaoResp, $tipo);
            return Helpers::successResponse($resposta);

        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }
}
