<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Helpers\Helpers;
use Illuminate\Support\Facades\DB;

class MateriaisController extends Controller
{
    //
    function materiais(Request $request){
        try{
            $idUser = $request->get('accountId');

            $materiaisResp = DB::select('select c.id, c.palestra_id, c.titulo, c.descricao, link, c.evento_id, e.descricao extensoes, c.permite_compartilhamento from conteudos c
                                            inner join extensoes e on e.id = c.extensao_id
                                            inner join inscricoes i on i.evento_id = c.evento_id
                                            inner join pessoas p on p.id = i.pessoa_id
                                                where c.ativo = 1
                                                and p.usuario_id = ?
                                            order by evento_id, e.descricao, c.id', [$idUser]);
            
            $tipo = [
                        "id" => "intVal",
                        "palestra_id" => "intVal",
                        "evento_id" => "intVal",
                        "permite_compartilhamento" => "boolVal",
                    ];
                                                                                
            $resposta = Helpers::convertTypes($materiaisResp, $tipo);
            return Helpers::successResponse($resposta);

        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function materiaisEvento(Request $request, $materiaisEvento){
        try{
            $idUser = $request->get('accountId');

            $materiaisResp = DB::select('select c.id, c.palestra_id, c.titulo, c.descricao, link, c.evento_id, e.descricao extensoes, c.permite_compartilhamento from conteudos c
                                            inner join extensoes e on e.id = c.extensao_id
                                            inner join inscricoes i on i.evento_id = c.evento_id
                                            inner join pessoas p on p.id = i.pessoa_id
                                                where c.ativo = 1
                                                and p.usuario_id = ?
                                                and c.evento_id = ?
                                            order by evento_id, e.descricao, c.id', [$idUser, $materiaisEvento]);
            
            $tipo = [
                        "id" => "intVal",
                        "palestra_id" => "intVal",
                        "evento_id" => "intVal",
                        "permite_compartilhamento" => "boolVal",
                    ];
                                                                                
            $resposta = Helpers::convertTypes($materiaisResp, $tipo);
            return Helpers::successResponse($resposta);

        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }
}
