<?php

namespace App\Http\Controllers;

use App\Helpers\Helpers;
use App\Jobs\firebasePainelOrganizadora;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Validator;

class EventosController extends Controller
{
    //
    function todosEventos(Request $request, $idEvento = 0)
    {
        try {

            $idUser = $request->get('accountId');

            $baseUrl = URL::to('/qrcode');

            $userFoto = DB::select('select hash from ERPUSB..Users where UsersId = ?', [$idUser]);

            if($userFoto[0]->hash != null){
                $imagemUser = $this->buscaImgApiERPUSB($userFoto[0]->hash);
            }

            $eventos = DB::select("select e.id id_evento, e.nome nome_evento, e.inicio, e.fim, e.aceita_inscricao_app, e.encerrado_inscricao, e.tempo_abertura_pergunta, e.descricao, e.pergunta_antes_evento, e.informacao, e.inscricao_fechada, e.inscricao_app_com_codigo,
                                                    concat(g.repositorio_imagem,e.foto) foto_evento_capa, REPLACE(RIGHT(e.foto, LEN(e.foto) - CHARINDEX('/', REVERSE(e.foto))) ,'/', '' ) nome_foto_evento_capa, e.aceita_pergunta_anonima, e.liberado_pergunta, e.fechado_inscricao_workshop, e.mostra_perguntas, e.varias_leituras, e.precisa_hotel, e.precisa_transporte, ce.id id_local, ce.descricao nome_local,
                                                    ce.ativo local_ativo, ce.tipo_logradouro, ce.cep, ce.logradouro, ce.numero, ce.complemento, ce.bairro, ce.cidade, ce.uf, ce.endereco_mapa,
                                                    (select case when uu.photo is not null then concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',uu.photo) else null end from inscricoes ii
                                                    inner join pessoas pp on pp.id = ii.pessoa_id
                                                    inner join ERPUSB..Users uu on uu.UsersId = pp.usuario_id
                                                    where ii.evento_id = e.id
                                                    order by ii.id desc
                                                    OFFSET 0 ROW
                                                    FETCH NEXT 1 ROWS ONLY) participante_1,
                                                    (select case when uu.photo is not null then uu.photo else null end from inscricoes ii
                                                    inner join pessoas pp on pp.id = ii.pessoa_id
                                                    inner join ERPUSB..Users uu on uu.UsersId = pp.usuario_id
                                                    where ii.evento_id = e.id
                                                    order by ii.id desc
                                                    OFFSET 0 ROW
                                                    FETCH NEXT 1 ROWS ONLY) participante_1_nome,
                                                    (select case when uu.photo is not null then concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',uu.photo) else null end from inscricoes ii
                                                    inner join pessoas pp on pp.id = ii.pessoa_id
                                                    inner join ERPUSB..Users uu on uu.UsersId = pp.usuario_id
                                                    where ii.evento_id = e.id
                                                    order by ii.id desc
                                                    OFFSET 1 ROW
                                                    FETCH NEXT 1 ROWS ONLY) participante_2,
                                                    (select case when uu.photo is not null then uu.photo else null end from inscricoes ii
                                                    inner join pessoas pp on pp.id = ii.pessoa_id
                                                    inner join ERPUSB..Users uu on uu.UsersId = pp.usuario_id
                                                    where ii.evento_id = e.id
                                                    order by ii.id desc
                                                    OFFSET 1 ROW
                                                    FETCH NEXT 1 ROWS ONLY) participante_2_nome,
                                                    (select case when uu.photo is not null then concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',uu.photo) else null end from inscricoes ii
                                                    inner join pessoas pp on pp.id = ii.pessoa_id
                                                    inner join ERPUSB..Users uu on uu.UsersId = pp.usuario_id
                                                    where ii.evento_id = e.id
                                                    order by ii.id desc
                                                    OFFSET 3 ROW
                                                    FETCH NEXT 1 ROWS ONLY) participante_3,
                                                    (select case when uu.photo is not null then uu.photo else null end from inscricoes ii
                                                    inner join pessoas pp on pp.id = ii.pessoa_id
                                                    inner join ERPUSB..Users uu on uu.UsersId = pp.usuario_id
                                                    where ii.evento_id = e.id
                                                    order by ii.id desc
                                                    OFFSET 3 ROW
                                                    FETCH NEXT 1 ROWS ONLY) participante_3_nome,
                                                    CONCAT(?,'/', RIGHT('0000000000' + CAST(i.id AS VARCHAR(10)), 10) ) qr_code,
                                                    concat(RIGHT('0000000000' + CAST(i.id AS VARCHAR(10)), 10),'.png') qr_code_nome,
                                                    RIGHT('0000000000' + CAST(i.id AS VARCHAR(10)), 10) matricula,
                                                    i.plenario_regiao_id,
                                                    i.organizadora_regiao_id,
                                                    p.nome,
                                                    p.funcao_id,
                                                    f.descricao funcao,
                                                    p.entidade_id,
                                                    en.Name entidade,
                                                    concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',u.photo) foto_pessoa,
                                                    u.photo foto_pessoa_nome,
                                                    (select count(id) from inscricoes iii where evento_id = e.id and cancelada = 0) qtd_evento,
                                                    case when (m.id is not null) then 1 else 0 end as moderador,
                                                    ent.Acronym sigla_entidade,
                                                    e.assembleia,
                                                    case when om.id is not null then 1 else 0 end comissao_organizadora,
                                                    (case when ef.conta_quorum = 1 and e.assembleia = 1 then 1 else 0 end) as comissao_plenario,
                                                    liberado_escolha_comissao_nomeacao,
                                                    liberado_escolha_comissao_organizadora,
                                                    e.liberado_leitura_observacao,
                                                    e.escolha_organizadora_tipo_id,
                                                    eot.descricao descricao_escolha_organizadora_tipo
                                                    from eventos e
                                            inner join inscricoes i on i.evento_id = e.id and i.cancelada = 0
                                            inner join pessoas p on p.id = i.pessoa_id
                                            inner join centro_eventos ce on ce.id = e.centro_evento_id
                                            inner join funcoes f on f.id = i.funcao_id
                                            inner join evento_funcoes ef on ef.evento_id = i.evento_id and ef.funcao_id = f.id
                                            inner join ERPUSB..Entity en on en.Entityid = p.entidade_id
                                             left join ERPUSB..Users u on u.UsersId = p.usuario_id
                                             left join moderadores m on m.evento_id = e.id and m.pessoa_id = p.id
                                             left join ERPUSB..Entity ent on ent.Entityid = e.entidade_id
                                             LEFT JOIN globais g on g.id = 1
                                             left join organizadora_membros om on om.evento_id = e.id and om.inscricao_id = i.id
                                             left join escolha_organizadora_tipos eot on eot.id = e.escolha_organizadora_tipo_id
                                            where p.usuario_id = ? and (? = e.id or ? = 0)

                                            union all

                                            select e.id id_evento, e.nome nome_evento, e.inicio, e.fim, e.aceita_inscricao_app, e.encerrado_inscricao, e.tempo_abertura_pergunta, e.descricao, e.pergunta_antes_evento, e.informacao, e.inscricao_fechada, e.inscricao_app_com_codigo,
                                                    concat(g.repositorio_imagem,e.foto) foto_evento_capa, REPLACE(RIGHT(e.foto, LEN(e.foto) - CHARINDEX('/', REVERSE(e.foto))) ,'/', '' ) nome_foto_evento_capa, e.aceita_pergunta_anonima, e.liberado_pergunta, e.fechado_inscricao_workshop, e.mostra_perguntas, e.varias_leituras, e.precisa_hotel, e.precisa_transporte, ce.id id_local, ce.descricao nome_local,
                                                    ce.ativo local_ativo, ce.tipo_logradouro, ce.cep, ce.logradouro, ce.numero, ce.complemento, ce.bairro, ce.cidade, ce.uf, ce.endereco_mapa,
                                                    (select case when uu.photo is not null then concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',uu.photo) else null end from inscricoes ii
                                                    inner join pessoas pp on pp.id = ii.pessoa_id
                                                    inner join ERPUSB..Users uu on uu.UsersId = pp.usuario_id
                                                    where ii.evento_id = e.id
                                                    order by ii.id desc
                                                    OFFSET 0 ROW
                                                    FETCH NEXT 1 ROWS ONLY) participante_1,
                                                    (select case when uu.photo is not null then uu.photo else null end from inscricoes ii
                                                    inner join pessoas pp on pp.id = ii.pessoa_id
                                                    inner join ERPUSB..Users uu on uu.UsersId = pp.usuario_id
                                                    where ii.evento_id = e.id
                                                    order by ii.id desc
                                                    OFFSET 0 ROW
                                                    FETCH NEXT 1 ROWS ONLY) participante_1_nome,
                                                    (select case when uu.photo is not null then concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',uu.photo) else null end from inscricoes ii
                                                    inner join pessoas pp on pp.id = ii.pessoa_id
                                                    inner join ERPUSB..Users uu on uu.UsersId = pp.usuario_id
                                                    where ii.evento_id = e.id
                                                    order by ii.id desc
                                                    OFFSET 1 ROW
                                                    FETCH NEXT 1 ROWS ONLY) participante_2,
                                                    (select case when uu.photo is not null then uu.photo else null end from inscricoes ii
                                                    inner join pessoas pp on pp.id = ii.pessoa_id
                                                    inner join ERPUSB..Users uu on uu.UsersId = pp.usuario_id
                                                    where ii.evento_id = e.id
                                                    order by ii.id desc
                                                    OFFSET 1 ROW
                                                    FETCH NEXT 1 ROWS ONLY) participante_2_nome,
                                                    (select case when uu.photo is not null then concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',uu.photo) else null end from inscricoes ii
                                                    inner join pessoas pp on pp.id = ii.pessoa_id
                                                    inner join ERPUSB..Users uu on uu.UsersId = pp.usuario_id
                                                    where ii.evento_id = e.id
                                                    order by ii.id desc
                                                    OFFSET 3 ROW
                                                    FETCH NEXT 1 ROWS ONLY) participante_3,
                                                    (select case when uu.photo is not null then uu.photo else null end from inscricoes ii
                                                    inner join pessoas pp on pp.id = ii.pessoa_id
                                                    inner join ERPUSB..Users uu on uu.UsersId = pp.usuario_id
                                                    where ii.evento_id = e.id
                                                    order by ii.id desc
                                                    OFFSET 3 ROW
                                                    FETCH NEXT 1 ROWS ONLY) participante_3_nome,
                                                    null qr_code,
                                                    null qr_code_nome,
                                                    null matricula,
                                                    null plenario_regiao_id,
                                                    null organizadora_regiao_id,
                                                    null nome,
                                                    null funcao_id,
                                                    null funcao,
                                                    null entidade_id,
                                                    null entidade,
                                                    null foto_pessoa,
                                                    null foto_pessoa_nome,
                                                    (select count(id) from inscricoes iii where evento_id = e.id and cancelada = 0) qtd_evento,
                                                    null as moderador,
                                                    ent.Acronym sigla_entidade,
                                                    0 assembleia,
                                                    0 comissao_organizadora,
                                                    0 comissao_plenario,
                                                    0 liberado_escolha_comissao_nomeacao,
                                                    0 liberado_escolha_comissao_organizadora,
                                                    e.liberado_leitura_observacao,
                                                    e.escolha_organizadora_tipo_id,
                                                    eot.descricao descricao_escolha_organizadora_tipo
                                                    from eventos e
                                            inner join centro_eventos ce on ce.id = e.centro_evento_id
                                             left join ERPUSB..Entity ent on ent.Entityid = e.entidade_id
                                             left join escolha_organizadora_tipos eot on eot.id = e.escolha_organizadora_tipo_id
                                             LEFT JOIN globais g on g.id = 1
                                            where e.aceita_inscricao_app = 1
                                                and e.inicio > GETDATE()
                                                and e.id not in(
                                                select ii.evento_id from pessoas pp
                                                inner join inscricoes ii on ii.pessoa_id = pp.id
                                                where pp.usuario_id = ?) and (? = e.id or ? = 0) and ( cast(e.fim as date) > cast(GETDATE() as date))
                                            ", [$baseUrl, $idUser, $idEvento, $idEvento, $idUser, $idEvento, $idEvento]);




            if (count($eventos) == 0) {
                if ($idEvento != 0) {
                    return Helpers::successResponse('');
                } else {
                    return Helpers::successResponse([]);
                }
            }

            foreach ($eventos as $evento) {
                if (!str_contains($evento->nome_foto_evento_capa, '.') && $evento->nome_foto_evento_capa != null) {
                    $apiResp = $this->buscaImgApi($evento->nome_foto_evento_capa);

                    if (!empty($apiResp)) {
                        $evento->foto_evento_capa = $apiResp['body']['url'];
                        $evento->nome_foto_evento_capa = $apiResp['body']['name'];
                    }
                }

                if (!str_contains($evento->participante_1_nome, '.') && $evento->participante_1_nome != null) {
                    $apiResp = $this->buscaImgApi($evento->participante_1_nome);

                    if (!empty($apiResp)) {
                        $evento->participante_1 = $apiResp['body']['url'];
                        $evento->participante_1_nome = $apiResp['body']['name'];
                    }
                }

                if (!str_contains($evento->participante_2_nome, '.') && $evento->participante_2_nome != null) {
                    $apiResp = $this->buscaImgApi($evento->participante_2_nome);

                    if (!empty($apiResp)) {
                        $evento->participante_2 = $apiResp['body']['url'];
                        $evento->participante_2_nome = $apiResp['body']['name'];
                    }
                }

                if (!str_contains($evento->participante_3_nome, '.') && $evento->participante_3_nome != null) {
                    $apiResp = $this->buscaImgApi($evento->participante_3_nome);

                    if (!empty($apiResp)) {
                        $evento->participante_3 = $apiResp['body']['url'];
                        $evento->participante_3_nome = $apiResp['body']['name'];
                    }
                }

                if (!empty($imagemUser)) {
                    $evento->foto_pessoa = $imagemUser['body']['url'];
                    $evento->foto_pessoa_nome = $imagemUser['body']['name'];
                }
            }

            $tipo = [
                "id_evento"                              => "intVal",
                "encerrado_inscricao"                    => "boolVal",
                "tempo_abertura_pergunta"                => "intVal",
                "pergunta_antes_evento"                  => "intVal",
                "inscricao_fechada"                      => "boolVal",
                "inscricao_app_com_codigo"               => "boolVal",
                "aceita_pergunta_anonima"                => "boolVal",
                "liberado_pergunta"                      => "boolVal",
                "fechado_inscricao_workshop"             => "boolVal",
                "mostra_perguntas"                       => "boolVal",
                "varias_leituras"                        => "boolVal",
                "precisa_hotel"                          => "boolVal",
                "precisa_transporte"                     => "boolVal",
                "local_ativo"                            => "boolVal",
                "funcao_id"                              => "intVal",
                "entidade_id"                            => "intVal",
                "aceita_inscricao_app"                   => "boolVal",
                "moderador"                              => "boolVal",
                "assembleia"                             => "boolVal",
                "comissao_organizadora"                  => "boolVal",
                "comissao_plenario"                      => "boolVal",
                "liberado_escolha_comissao_nomeacao"     => "boolVal",
                "liberado_escolha_comissao_organizadora" => "boolVal",
                "liberado_leitura_observacao"            => "boolVal",
                "escolha_organizadora_tipo_id"           => "intVal"
            ];

            $resposta = Helpers::convertTypes($eventos, $tipo);

            if ($idEvento != 0) {
                return Helpers::successResponse($resposta[0]);
            } else {
                return Helpers::successResponse($resposta);
            }
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function presencaEvento(Request $request)
    {
        try {

            $content = $request->getContent();
            $data = json_decode($content, true);

            $foto = "https://sistemas.usb.org.br/uploads/sistemasusb/usuarios/avatar-default.png";

            $idUser = $request->get('accountId');

            $validacao = Validator::make(
                $data,
                [
                    'idEvento' => 'required|Int',
                    'idInscription' => 'required|Int',
                ],
                [
                    'idEvento' => 'Informe o idEvento',
                    'idInscription' => 'Informe um numero de inscricao',
                ]
            );

            if ($validacao->fails()) {
                return Helpers::errorResponse($validacao->errors(), 500);
            }

            if ($request->has('idPalestra')) {
                $idPaletra = $data['idPalestra'];
            } else {
                $idPaletra = 0;
            }

            $inscricaoExiste = DB::select("select i.id, i.evento_id, p.nome, concat('https://sistemas.usb.org.br/uploads/sistemasusb/usuarios/',isnull(u.photo,'avatar-default.png')) foto, u.hash from inscricoes i
                                                inner join pessoas p on p.id = i.pessoa_id
                                                left join ERPUSB..Users u on u.UsersId = p.usuario_id
                                                where i.id = ? and i.evento_id = ?", [$data['idInscription'], $data['idEvento']]);

            if (count($inscricaoExiste) === 0) {
                return $this->retornaInscricao(0, "Não Encontrado", $foto, "Matricula não encontrada", $data['idInscription']);
            }

            $foto = $inscricaoExiste[0]->foto;

            $apiResp = $this->buscaImgApiERPUSB($inscricaoExiste[0]->hash);

            if (!empty($apiResp)) {
                $foto = $apiResp['body']['url'];
                //$evento->foto_pessoa_nome = $apiResp['body']['name'];
            }

            $presencaExiste = DB::select('select i.id, e.varias_leituras, count(p.id) qtd_presenca, case when (max(cast(p.horario as date)) = cast(GETDATE() as date)) then 1 else 0 end libera_data from inscricoes i
                                            inner join eventos e on e.id = i.evento_id
                                            left join presencas p on p.inscricao_id = i.id and (palestra_id = ? or ? = 0)
                                            where i.id = ?
                                            GROUP by i.id, e.varias_leituras', [$idPaletra, $idPaletra, $data['idInscription']]);

            if ($presencaExiste[0]->qtd_presenca == 0) {
                return $this->marcaPresenca($data['idInscription'], $inscricaoExiste[0]->evento_id, $inscricaoExiste[0]->nome, $foto, $idPaletra);
            }

            if ($presencaExiste[0]->varias_leituras == 0 && $presencaExiste[0]->libera_data == 1) {
                return $this->retornaInscricao(0, $inscricaoExiste[0]->nome, $foto, "O usuário já possui presença confirmada neste evento.", $data['idInscription']);
            }

            // if($presencaExiste[0]->varias_leituras == 1){
            //     return $this->retornaInscricao(0,$inscricaoExiste[0]->nome,$inscricaoExiste[0]->foto,"O usuário já possui presença confirmada para esse dia no evento.",$data['idInscription']);
            // }

            return $this->marcaPresenca($data['idInscription'], $inscricaoExiste[0]->evento_id, $inscricaoExiste[0]->nome, $foto, $idPaletra);
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function marcaPresenca($inscricao, $idEvento, $nome, $foto, $idPaletra)
    {

        if ($idPaletra == 0) {
            DB::insert(
                'insert into presencas (horario, created_at, updated_at, inscricao_id, evento_id, tipo) values (GETDATE(),GETDATE(),GETDATE(),?,?,?)',
                [$inscricao, $idEvento, 'E']
            );
        } else {
            DB::insert(
                'insert into presencas (horario, created_at, updated_at, inscricao_id, evento_id, tipo, palestra_id) values (GETDATE(),GETDATE(),GETDATE(),?,?,?,?)',
                [$inscricao, $idEvento, 'E', $idPaletra]
            );
        }


        return $this->retornaInscricao(1, $nome, $foto, "Sucesso! Presença registrada com sucesso para {$nome}.", $inscricao);
    }

    function retornaInscricao($gerado, $nome, $foto, $msg, $inscricao)
    {

        $returnResult['gerado']    = boolVal($gerado);
        $returnResult['nome']      = $nome;
        $returnResult['foto']      = $foto;
        $returnResult['msg']       = $msg;
        $returnResult['inscricao'] = intval($inscricao);

        return Helpers::successResponse($returnResult);
    }

    function programacao(Request $request, $idEvento = 0)
    {
        try {
            $idUser = $request->get('accountId');

            $programacaoResp = DB::select("SELECT i.evento_id,
                                        e.nome       nome_evento,
                                        tp.id        id_tipo_palestra,
                                        tp.descricao tipo_palestra,
                                        pa.id        palestra_id,
                                        pa.inicio,
                                        pa.fim,
                                        pa.titulo,
                                        pa.resumo,
                                        video,
                                        concat(g.repositorio_imagem,pa.foto) foto,
                                        s.id         id_sala,
                                        s.descricao  nome_sala,
                                        CASE
                                        WHEN ipe.id IS NOT NULL THEN 1
                                        ELSE 0
                                        END          inscrito,
                                        pa.liberado_pergunta,
                                        pa.aceita_pergunta_anonima,
                                        pa.permite_perguntas
                                FROM   pessoas p
                                        INNER JOIN inscricoes i
                                                ON i.pessoa_id = p.id
                                        INNER JOIN palestras pa
                                                ON pa.evento_id = i.evento_id
                                        INNER JOIN tipo_palestras tp
                                                ON tp.id = pa.tipo_palestra_id
                                        INNER JOIN salas s
                                                ON s.id = pa.sala_id
                                        INNER JOIN eventos e
                                                ON e.id = i.evento_id
                                        LEFT JOIN inscricao_evento_palestras ipe
                                            ON ipe.inscricao_id = i.id
                                                AND ipe.palestra_id = pa.id
                                        LEFT JOIN globais g on g.id = 1
                                WHERE  p.usuario_id = ? and (e.id = ? or ? = 0)
                                ORDER  BY i.evento_id,
                                        pa.inicio,
                                        tp.id ", [$idUser, $idEvento, $idEvento]);

            $tipo = [
                "inscrito" => "boolVal",
                "evento_id" => "intVal",
                "id_tipo_palestra" => "intVal",
                "palestra_id" => "intVal",
                "id_sala" => "intVal",
                "liberado_pergunta" => "boolVal",
                "aceita_pergunta_anonima" => "boolVal",
                "permite_perguntas" => "boolVal",
            ];

            $resposta = Helpers::convertTypes($programacaoResp, $tipo);


            return Helpers::successResponse($resposta);
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function palestrante(Request $request, $idEvento = 0)
    {
        try {

            $idUser = $request->get('accountId');

            $palestranteResp = DB::select("SELECT pl.palestra_id, pa.evento_id ,pl.id id_palestrante, pp.nome, pc.descricao, pc.instituicao, case when u.photo is not null then concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',u.photo) else null end foto, u.photo nome_foto
                                            FROM   pessoas p
                                                    INNER JOIN inscricoes i
                                                            ON i.pessoa_id = p.id
                                                    INNER JOIN palestras pa
                                                            ON pa.evento_id = i.evento_id
                                                    INNER JOIN palestrantes pl on pl.palestra_id = pa.id
                                                    INNER JOIN pessoas pp on pp.id = pl.pessoa_id
                                                    LEFT JOIN pessoa_curriculos pc on pc.pessoa_id = pp.id
                                                    LEFT JOIN ERPUSB..Users u on u.UsersId = pp.usuario_id
                                                    LEFT JOIN globais g on g.id = 1
                                            WHERE  p.usuario_id = ? and (i.evento_id = ? or ? = 0)
                                            ORDER  BY i.evento_id,
                                                    pa.inicio", [$idUser, $idEvento, $idEvento]);

            $tipo = [
                "palestra_id" => "intVal",
                "evento_id" => "intVal",
                "id_palestrante" => "intVal",
            ];

            $resposta = Helpers::convertTypes($palestranteResp, $tipo);


            return Helpers::successResponse($resposta);
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function buscaImgApi($token)
    {
        try {
            $resposta = Http::get(env('URL_API_PHOTO') . '/' . env('TOKEN_V_API_PHOTO') . '/' . $token);
            if ($resposta->successful()) {
                $data = $resposta->json();
            } else {
                $data = [];
            }

            return $data;
        } catch (\Exception $e) {
        }
    }

    function buscaImgApiERPUSB($token)
    {
        try {
            $resposta = Http::get(env('URL_API_PHOTO') . '/' . env('TOKEN_V_API_PHOTO_ERPUSB') . '/' . $token);
            if ($resposta->successful()) {
                $data = $resposta->json();
            } else {
                $data = [];
            }

            return $data;
        } catch (\Exception $e) {
        }
    }

    function lista_presenca(Request $request, $idEvento = 0)
    {
        try {
            $idUser = $request->get('accountId');

            $listaEvento = DB::select('select i.id inscricao_id, i.evento_id, palestra_id, pu.id pessoa_id ,pu.nome from pessoas p
                                        inner join moderadores m on m.pessoa_id = p.id
                                        inner join inscricoes i on i.evento_id = m.evento_id
                                        inner join pessoas pu on pu.id = i.pessoa_id
                                        inner join eventos e on e.id = i.evento_id
                                        left join inscricao_evento_palestras iep on iep.inscricao_id = i.id
                                        where p.usuario_id = ? and (e.id = ? or ? = 0)
                                        and cast(e.fim as date) > CAST(GETDATE() as date)
                                        order by i.evento_id', [$idUser, $idEvento, $idEvento]);

            $tipo = [
                "inscricao_id" => "intVal",
                "evento_id" => "intVal",
                "palestra_id" => "intVal",
                "pessoa_id" => "intVal",
            ];

            $resposta = Helpers::convertTypes($listaEvento, $tipo);

            return Helpers::successResponse($resposta);
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function listaMembrosComissaoOrganizadora(Request $request)
    {
        $idEvento = $request->input('idEvento');
        $idRegiaoPlenario = $request->input('idRegiaoPlenario');

        $validacao = Validator::make(
            $request->input(),
            [
                'idEvento' => 'required|Int',
                'idRegiaoPlenario' => 'required|Int',
            ],
            [
                'idEvento' => 'Informe o idEvento',
                'idRegiaoPlenario' => 'Informe o idRegiaoPlenario',
            ]
        );

        if ($validacao->fails()) {
            return Helpers::errorResponse($validacao->errors(), 400);
        }

        try {
            $listaMembros = DB::select("
            select  i.id inscricao_id,
                    p.nome,
                    u.Email email,
                    r.descricao as funcao,
                    pr.descricao as regiao,
                    (CASE when u.photo is null then null else concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',u.photo) end) foto,
                    u.photo foto_nome,
                    i.evento_id,
                    p.id pessoa_id,
                    ef.conta_quorum,
                    om.id as membro_id,
                    u.hash,
                    ore.descricao as regiao_organizadora,
                    e.escolha_organizadora_tipo_id

            from    inscricoes i
                    inner join pessoas p on p.id = i.pessoa_id
                    inner join erpusb.dbo.Users u on u.Usersid = p.usuario_id
                    inner join eventos e on e.id = i.evento_id
                    inner join evento_funcoes ef on ef.funcao_id = i.funcao_id and ef.evento_id = e.id
                    inner join globais g on g.id = 1
                    left join organizadora_membros om on om.inscricao_id = i.id and om.evento_id = ?
                    left join representacoes r on r.id = i.representacao_id
                    left join plenario_regioes pr on pr.id = i.plenario_regiao_id
                    left join organizadora_regioes ore on ore.id = i.organizadora_regiao_id

            where   i.evento_id            = ? and
                    i.plenario_regiao_id = ? and
                    cancelada = 0 and
                    ef.conta_quorum        = 1 and NOT EXISTS (
                        SELECT 1
                        FROM organizadora_membros
                        WHERE organizadora_membros.inscricao_id = i.id and organizadora_membros.evento_id = ?)
                    AND exists (select p.id from presencas  p
                        where   p.evento_id         = i.evento_id and
                                p.tipo              = 'E' and
                                p.inscricao_id      = i.id)
            order by p.nome asc", [$idEvento, $idEvento, $idRegiaoPlenario, $idEvento]);

            $listaImagem = [];

            foreach ($listaMembros as $membro) {
                if($membro->hash != null){
                    $valorProcurado = $membro->hash;
                    $validaArray = array_filter($listaImagem, function($imagem) use ($valorProcurado) { return $imagem['hash'] === $valorProcurado; });
                    if(count($validaArray) == 0){
                        $listaImagem[] = ['hash' => $valorProcurado, 'nome' => '', 'url' => ''];
                    }
                }
            }

            foreach (array_keys($listaImagem) as $index){
                $novaUrlValor = $this->buscaImgApiERPUSB($listaImagem[$index]['hash']);
                if($novaUrlValor['error'] === null){
                    $listaImagem[$index]['nome'] = $novaUrlValor['body']['name'];
                    $listaImagem[$index]['url'] = $novaUrlValor['body']['url'];

                    foreach ($listaMembros as $posicao => $membro) {
                        if ($membro->hash == $listaImagem[$index]['hash']) {
                            $listaMembros[$posicao]->foto_nome = $novaUrlValor['body']['name'];
                            $listaMembros[$posicao]->foto      = $novaUrlValor['body']['url'];
                        }
                    }
                }
            }

            $tipo = [
                "conta_quorum" => "boolVal"
            ];
            $resposta = Helpers::convertTypes($listaMembros, $tipo);
            return Helpers::successResponse($resposta);
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function listaMembrosComissaoNomeacao(Request $request)
    {
        $idEvento = $request->input('idEvento');
        $idRegiaoOrganizadora = $request->input('idRegiaoOrganizadora');
        $idUser = $request->get('accountId');

        $validacao = Validator::make(
            $request->input(),
            [
                'idEvento' => 'required|Int',
                'idRegiaoOrganizadora' => 'required|Int',
            ],
            [
                'idEvento' => 'Informe o idEvento',
                'idRegiaoOrganizadora' => 'Informe o idRegiaoOrganizadora',
            ]
        );

        if ($validacao->fails()) {
            return Helpers::errorResponse($validacao->errors(), 400);
        }

        try {
            // $listaMembros = DB::select("
            // select  i.id inscricao_id,
            //         p.nome,
            //         u.Email email,
            //         r.descricao as funcao,
            //         ore.descricao as regiao,
            //         (CASE when u.photo is null then null else concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',u.photo) end) foto,
            //         u.photo foto_nome,
            //         i.evento_id,
            //         p.id pessoa_id,
            //         ef.conta_quorum,
            //         nm.id as membro_id,
            //         u.hash

            // from    inscricoes i
            //         inner join pessoas p on p.id = i.pessoa_id
            //         inner join erpusb.dbo.Users u on u.Usersid = p.usuario_id
            //         inner join eventos e on e.id = i.evento_id
            //         inner join evento_funcoes ef on ef.funcao_id = i.funcao_id and ef.evento_id = e.id
            //         inner join globais g on g.id = 1
            //         left join nomeacao_membros nm on nm.inscricao_id = i.id and nm.evento_id = i.evento_id
            //         left join representacoes r on r.id = i.representacao_id
            //         left join organizadora_regioes ore on ore.id = i.organizadora_regiao_id

            // where   i.evento_id            = ? and
            //         i.organizadora_regiao_id = ? and
            //         ef.conta_quorum = 1 and NOT EXISTS (
            //             SELECT 1
            //             FROM nomeacao_membros
            //             WHERE nomeacao_membros.inscricao_id = i.id and nomeacao_membros.evento_id = ?)
            //             and EXISTS (
            //                 select i.id inscricao_id from inscricoes i
            //                 inner join pessoas p on p.id = i.pessoa_id
            //                 inner join organizadora_membros ore on ore.inscricao_id = i.id and ore.evento_id = i.evento_id
            //                 where i.evento_id = ? and p.usuario_id = ?) and not exists (select om.id
            //                     from organizadora_membros om
            //                     where om.inscricao_id = i.id and
            //                     om.evento_id = i.evento_id and
            //                     ore.somente_plenario = 1)
            // order by p.nome asc", [$idEvento, $idRegiaoOrganizadora, $idEvento, $idEvento, $idUser]);

            $listaMembros = DB::select("
            select  i.id inscricao_id,
                    p.nome,
                    u.Email email,
                    r.descricao as funcao,
                    pr.descricao as regiao,
                    (CASE when u.photo is null then null else concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',u.photo) end) foto,
                    u.photo foto_nome,
                    i.evento_id,
                    p.id pessoa_id,
                    ef.conta_quorum,
                    om.id as membro_id,
                    u.hash,
                    ore.descricao as regiao_organizadora

            from    inscricoes i
                    inner join pessoas p on p.id = i.pessoa_id
                    inner join erpusb.dbo.Users u on u.Usersid = p.usuario_id
                    inner join eventos e on e.id = i.evento_id
                    inner join evento_funcoes ef on ef.funcao_id = i.funcao_id and ef.evento_id = e.id
                    inner join globais g on g.id = 1
                    inner join plenario_regioes pr on pr.id = i.plenario_regiao_id
                    inner join organizadora_regioes ore on ore.id = i.organizadora_regiao_id
                    inner join representacoes r on r.id = i.representacao_id
                    left join organizadora_membros om on om.inscricao_id = i.id and om.evento_id = i.evento_id

            where   i.evento_id              = ? and
                    i.organizadora_regiao_id = ? and
                    ef.conta_quorum          = 1 and
                    cancelada = 0
                     AND ((ore.somente_plenario = 0 and i.organizadora_regiao_id = ore.id) or
                            (ore.somente_plenario = 1 and i.organizadora_regiao_id = ore.id and om.inscricao_id is null))
                    and NOT EXISTS (
                                SELECT 1
                                FROM nomeacao_membros
                                WHERE nomeacao_membros.inscricao_id = i.id and nomeacao_membros.evento_id = e.id)

            order by p.nome asc", [$idEvento, $idRegiaoOrganizadora]);

            $listaImagem = [];

            foreach ($listaMembros as $membro) {
                if($membro->hash != null){
                    $valorProcurado = $membro->hash;
                    $validaArray = array_filter($listaImagem, function($imagem) use ($valorProcurado) { return $imagem['hash'] === $valorProcurado; });
                    if(count($validaArray) == 0){
                        $listaImagem[] = ['hash' => $valorProcurado, 'nome' => '', 'url' => ''];
                    }
                }
            }

            foreach (array_keys($listaImagem) as $index){
                $novaUrlValor = $this->buscaImgApiERPUSB($listaImagem[$index]['hash']);
                if($novaUrlValor['error'] === null){
                    $listaImagem[$index]['nome'] = $novaUrlValor['body']['name'];
                    $listaImagem[$index]['url'] = $novaUrlValor['body']['url'];

                    foreach ($listaMembros as $posicao => $membro) {
                        if ($membro->hash == $listaImagem[$index]['hash']) {
                            $listaMembros[$posicao]->foto_nome = $novaUrlValor['body']['name'];
                            $listaMembros[$posicao]->foto      = $novaUrlValor['body']['url'];
                        }
                    }
                }
            }

            $tipo = [
                "conta_quorum" => "boolVal"
            ];
            $resposta = Helpers::convertTypes($listaMembros, $tipo);
            return Helpers::successResponse($resposta);
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function salvaMembroNomeacao(Request $request)
    {
        try {

            $content = $request->getContent();
            $data = json_decode($content, true);

            $validacao = Validator::make(
                $request->input(),
                [
                    'idEvento' => 'required|Int',
                    'idInscricao' => 'required|Int',
                ],
                [
                    'idEvento' => 'Informe o campo idEvento',
                    'idInscricao' => 'Informe o campo idInscricao',
                ]
            );

            if ($validacao->fails()) {
                return Helpers::errorResponse($validacao->errors(), 500);
            }

            $eventoLiberado = DB::select('select liberado_escolha_comissao_nomeacao from eventos where id = ?', [$data['idEvento']]);

            if($eventoLiberado[0]->liberado_escolha_comissao_nomeacao === 0){
                return Helpers::errorResponse("Comissão de nomeações ainda não está liberada para este evento.",400);
            }

            if ($request->has('regiao')) {
                $qtdRep = DB::select('select orr.descricao ,orr.numero_representantes, count(nm.id) atual from inscricoes i
                                        inner join organizadora_regioes orr on orr.id = i.organizadora_regiao_id
                                        left join nomeacao_membros nm on nm.evento_id = i.evento_id and nm.inscricao_id = i.id
                                        where i.evento_id = ?
                                        and orr.descricao = ?
                                        group by orr.descricao ,orr.numero_representantes', [$data['idEvento'], $data['regiao']]);

                if ($qtdRep[0]->numero_representantes <= $qtdRep[0]->atual) {
                    return Helpers::errorResponse('Numero maximo de membros escolhidos', 400);
                }
            }

            $existMembro = DB::select("select id from nomeacao_membros where evento_id = ? and inscricao_id = ?", [$data['idEvento'], $data['idInscricao']]);

            if (count($existMembro) == 0) {
                $verificaInsercao = DB::select("select om.id
                                                from inscricoes i
                                                inner join  organizadora_membros om on om.evento_id = i.evento_id and om.inscricao_id = i.id
                                                inner join organizadora_regioes ore on ore.id = i.organizadora_regiao_id
                                                where om.inscricao_id = ? and
                                                        om.evento_id =  ? and
                        ore.somente_plenario    = 1", [$data['idInscricao'], $data['idEvento']]);

                if (count($verificaInsercao) == 0) {
                    DB::insert('insert into nomeacao_membros VALUES (?, ?, GETDATE(), GETDATE())', [$data['idEvento'], $data['idInscricao']]);
                    return Helpers::successResponse('Membro salvo com sucesso.');
                } else {
                    return Helpers::errorResponse('Membro não pode ser selecionado.', 400);
                }
            } else {
                return Helpers::errorResponse('Membro já selecionado.', 400);
            }
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function salvaMembroOrganizadora(Request $request)
    {
        try {

            $content = $request->getContent();
            $data = json_decode($content, true);

            $validacao = Validator::make(
                $request->input(),
                [
                    'idEvento' => 'required|Int',
                    'idInscricao' => 'required|Int',
                ],
                [
                    'idEvento' => 'Informe o campo idEvento',
                    'idInscricao' => 'Informe o campo idInscricao',
                ]
            );

            if ($validacao->fails()) {
                return Helpers::errorResponse($validacao->errors(), 500);
            }

            $eventoLiberado = DB::select('select * from eventos where id = ?', [$data['idEvento']]);

            if($eventoLiberado[0]->liberado_escolha_comissao_organizadora === 0){
                return Helpers::errorResponse("Comissão Organizadora ainda não está liberada para este evento.",400);
            }

            $existeRegiao = DB::select('
                                    select * from inscricoes ii
                                        where ii.evento_id = ?
                                        and ii.id = ?
                                        and ii.plenario_regiao_id not in(
                                            select distinct plenario_regiao_id from organizadora_membros om2
                                            inner join inscricoes i2 on i2.id = om2.inscricao_id
                                            where om2.evento_id = ?)
                                    ', [$data['idEvento'], $data['idInscricao'], $data['idEvento']]);

            if (count($existeRegiao) == 0) {
                return Helpers::errorResponse('Membro de Região já selecionado.',400);
            }

            $existMembro = DB::select("select id, evento_id from organizadora_membros where evento_id = ? and inscricao_id = ?", [$data['idEvento'], $data['idInscricao']]);
            //dd($data['idEvento']);
            if (count($existMembro) == 0) {
                DB::insert('insert into organizadora_membros VALUES (?, ?, GETDATE(), GETDATE())', [$data['idEvento'], $data['idInscricao']]);
                $this->atualizapainelorganizadora($data['idEvento']);
                return Helpers::successResponse('Membro salvo com sucesso.');
            } else {
                return Helpers::errorResponse('Membro já selecionado.',400);
            }
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function numeroRepresentantesNomeacao(Request $request)
    {
        $idEvento = $request->input('idEvento');
        $idRegiaoOrganizadora = $request->input('idRegiaoOrganizadora');

        $validacao = Validator::make(
            $request->input(),
            [
                'idEvento' => 'required|Int',
                'idRegiaoOrganizadora' => 'required|Int',
            ],
            [
                'idEvento' => 'Informe o idEvento',
                'idRegiaoOrganizadora' => 'Informe o idRegiaoOrganizadora',
            ]
        );

        if ($validacao->fails()) {
            return Helpers::errorResponse($validacao->errors(), 400);
        }

        try {
            $numeroRepresentantes = DB::select("
            select ore.id,
                    ore.descricao as regiao_organizadora,
                    ore.numero_representantes,
                    (select count(nm.id)
                        from nomeacao_membros nm
                            inner join inscricoes i on i.id = nm.inscricao_id and i.evento_id = e.id and i.organizadora_regiao_id = ore.id
                        where nm.evento_id = e.id
                        ) as numero_representantes_selecionados

                        from organizadora_regioes ore
                        inner join eventos e on e.id = ore.evento_id
                        where ore.evento_id = ? and ore.id = ?", [$idEvento, $idRegiaoOrganizadora]);

            $tipo = [];
            $resposta = Helpers::convertTypes($numeroRepresentantes, $tipo);
            if (count($resposta) > 0) {
                return Helpers::successResponse($resposta[0]);
            } else {
                return Helpers::successResponse([
                    'numero_representantes_selecionados' => 0,
                    'numero_representantes' => 0
                ]);
            }
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function listaMembrosAdicionadosComissaoOrganizadora(Request $request)
    {
        $idEvento = $request->input('idEvento');
        $idRegiaoPlenario = $request->input('idRegiaoPlenario');

        $validacao = Validator::make(
            $request->input(),
            [
                'idEvento' => 'required|Int',
                'idRegiaoPlenario' => 'required|Int',
            ],
            [
                'idEvento' => 'Informe o idEvento',
                'idRegiaoPlenario' => 'Informe o idRegiaoPlenario',
            ]
        );

        if ($validacao->fails()) {
            return Helpers::errorResponse($validacao->errors(), 400);
        }

        try {
            $listaMembros = DB::select("
            select  i.id inscricao_id,
                    p.nome,
                    u.Email email,
                    r.descricao as funcao,
                    pr.descricao as regiao,
                    (CASE when u.photo is null then null else concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',u.photo) end) foto,
                    u.photo foto_nome,
                    i.evento_id,
                    p.id pessoa_id,
                    ef.conta_quorum,
                    om.id as membro_id,
                    u.hash,
                    ore.descricao as regiao_organizadora,
                    e.escolha_organizadora_tipo_id

            from    inscricoes i
                    inner join pessoas p on p.id = i.pessoa_id
                    inner join erpusb.dbo.Users u on u.Usersid = p.usuario_id
                    inner join eventos e on e.id = i.evento_id
                    inner join evento_funcoes ef on ef.funcao_id = i.funcao_id and ef.evento_id = e.id
                    inner join globais g on g.id = 1
                    left join organizadora_membros om on om.inscricao_id = i.id and om.evento_id = ?
                    left join representacoes r on r.id = i.representacao_id
                    left join plenario_regioes pr on pr.id = i.plenario_regiao_id
                    left join organizadora_regioes ore on ore.id = i.organizadora_regiao_id

            where   i.evento_id            = ? and
                    i.plenario_regiao_id = ? and
                    ef.conta_quorum        = 1 and EXISTS (
                        SELECT 1
                        FROM organizadora_membros
                        WHERE organizadora_membros.inscricao_id = i.id and organizadora_membros.evento_id = ?)
            order by p.nome asc", [$idEvento, $idEvento, $idRegiaoPlenario, $idEvento]);

            $listaImagem = [];

            foreach ($listaMembros as $membro) {
                if($membro->hash != null){
                    $valorProcurado = $membro->hash;
                    $validaArray = array_filter($listaImagem, function($imagem) use ($valorProcurado) { return $imagem['hash'] === $valorProcurado; });
                    if(count($validaArray) == 0){
                        $listaImagem[] = ['hash' => $valorProcurado, 'nome' => '', 'url' => ''];
                    }
                }
            }

            foreach (array_keys($listaImagem) as $index){
                $novaUrlValor = $this->buscaImgApiERPUSB($listaImagem[$index]['hash']);
                if($novaUrlValor['error'] === null){
                    $listaImagem[$index]['nome'] = $novaUrlValor['body']['name'];
                    $listaImagem[$index]['url'] = $novaUrlValor['body']['url'];

                    foreach ($listaMembros as $posicao => $membro) {
                        if ($membro->hash == $listaImagem[$index]['hash']) {
                            $listaMembros[$posicao]->foto_nome = $novaUrlValor['body']['name'];
                            $listaMembros[$posicao]->foto      = $novaUrlValor['body']['url'];
                        }
                    }
                }
            }

            $tipo = [
                "conta_quorum" => "boolVal"
            ];
            $resposta = Helpers::convertTypes($listaMembros, $tipo);
            return Helpers::successResponse($resposta);
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function listaMembrosAdicionadosComissaoNomeacao(Request $request)
    {
        $idEvento = $request->input('idEvento');
        $idRegiaoOrganizadora = $request->input('idRegiaoOrganizadora');

        $validacao = Validator::make(
            $request->input(),
            [
                'idEvento' => 'required|Int',
                'idRegiaoOrganizadora' => 'required|Int',
            ],
            [
                'idEvento' => 'Informe o idEvento',
                'idRegiaoOrganizadora' => 'Informe o idRegiaoOrganizadora',
            ]
        );

        if ($validacao->fails()) {
            return Helpers::errorResponse($validacao->errors(), 400);
        }

        try {
            $listaMembros = DB::select("
            select  i.id inscricao_id,
                    p.nome,
                    u.Email email,
                    r.descricao as funcao,
                    ore.descricao as regiao,
                    (CASE when u.photo is null then null else concat(g.repositorio_imagem,'/uploads/sistemasusb/usuarios/',u.photo) end) foto,
                    u.photo foto_nome,
                    i.evento_id,
                    p.id pessoa_id,
                    ef.conta_quorum,
                    nm.id as membro_id,
                    u.hash

            from    inscricoes i
                    inner join pessoas p on p.id = i.pessoa_id
                    inner join erpusb.dbo.Users u on u.Usersid = p.usuario_id
                    inner join eventos e on e.id = i.evento_id
                    inner join evento_funcoes ef on ef.funcao_id = i.funcao_id and ef.evento_id = e.id
                    inner join globais g on g.id = 1
                    left join nomeacao_membros nm on nm.inscricao_id = i.id and nm.evento_id = ?
                    left join representacoes r on r.id = i.representacao_id
                    left join organizadora_regioes ore on ore.id = i.organizadora_regiao_id

            where   i.evento_id            = ? and
                    i.organizadora_regiao_id = ? and
                    ef.conta_quorum = 1 and EXISTS (
                        SELECT 1
                        FROM nomeacao_membros
                        WHERE nomeacao_membros.inscricao_id = i.id and nomeacao_membros.evento_id = ?)
            order by p.nome asc", [$idEvento, $idEvento, $idRegiaoOrganizadora, $idEvento]);

            $listaImagem = [];

            foreach ($listaMembros as $membro) {
                if($membro->hash != null){
                    $valorProcurado = $membro->hash;
                    $validaArray = array_filter($listaImagem, function($imagem) use ($valorProcurado) { return $imagem['hash'] === $valorProcurado; });
                    if(count($validaArray) == 0){
                        $listaImagem[] = ['hash' => $valorProcurado, 'nome' => '', 'url' => ''];
                    }
                }
            }

            foreach (array_keys($listaImagem) as $index){
                $novaUrlValor = $this->buscaImgApiERPUSB($listaImagem[$index]['hash']);
                if($novaUrlValor['error'] === null){
                    $listaImagem[$index]['nome'] = $novaUrlValor['body']['name'];
                    $listaImagem[$index]['url'] = $novaUrlValor['body']['url'];

                    foreach ($listaMembros as $posicao => $membro) {
                        if ($membro->hash == $listaImagem[$index]['hash']) {
                            $listaMembros[$posicao]->foto_nome = $novaUrlValor['body']['name'];
                            $listaMembros[$posicao]->foto      = $novaUrlValor['body']['url'];
                        }
                    }
                }
            }

            $tipo = [
                "conta_quorum" => "boolVal"
            ];
            $resposta = Helpers::convertTypes($listaMembros, $tipo);
            return Helpers::successResponse($resposta);
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function removeMembroOrganizadora(Request $request)
    {
        try {

            $validacao = Validator::make(
                $request->input(),
                [
                    'idMembroComissao' => 'required|Int'
                ],
                [
                    'idMembroComissao' => 'Informe o campo idMembroComissao'
                ]
            );

            if ($validacao->fails()) {
                return Helpers::errorResponse($validacao->errors(), 500);
            }

            $idMembroComissao = $request->input('idMembroComissao');
            $existMembro = DB::select("select id, evento_id from organizadora_membros where id = ?", [$idMembroComissao]);
            $eventoLiberado = DB::select('select * from eventos where id = ?', [$existMembro[0]->evento_id]);

            if($eventoLiberado[0]->liberado_escolha_comissao_organizadora === 0){
                return Helpers::errorResponse("Comissão Organizadora ainda não está liberada para este evento.",400);
            }

            if (count($existMembro) > 0) {
                DB::delete('delete organizadora_membros where id  = ?', [$idMembroComissao]);
                $this->atualizapainelorganizadora($existMembro[0]->evento_id);
                return Helpers::successResponse('Membro removido com sucesso.');
            } else {
                return Helpers::successResponse('Membro já removido.');
            }

        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function removeMembroNomeacao(Request $request)
    {
        try {

            $validacao = Validator::make(
                $request->input(),
                [
                    'idMembroComissao' => 'required|Int'
                ],
                [
                    'idMembroComissao' => 'Informe o campo idMembroComissao'
                ]
            );

            if ($validacao->fails()) {
                return Helpers::errorResponse($validacao->errors(), 500);
            }

            $idMembroComissao = $request->input('idMembroComissao');
            $existMembro = DB::select("select id, evento_id from nomeacao_membros where id = ?", [$idMembroComissao]);

            $eventoLiberado = DB::select('select liberado_escolha_comissao_nomeacao from eventos where id = ?', [$existMembro[0]->evento_id]);

            if($eventoLiberado[0]->liberado_escolha_comissao_nomeacao === 0){
                return Helpers::errorResponse("Comissão de nomeações ainda não está liberada para este evento.",400);
            }

            if ($existMembro) {
                DB::delete('delete nomeacao_membros where id  = ?', [$idMembroComissao]);

                return Helpers::successResponse('Membro removido com sucesso.');
            } else {
                return Helpers::successResponse('Membro já removido.');
            }
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function observacaoMembros(Request $request)
    {
        try {

            $content = $request->getContent();
            $data = json_decode($content, true);

            $foto = "https://sistemas.usb.org.br/uploads/sistemasusb/usuarios/avatar-default.png";

            $idUser = $request->get('accountId');

            $validacao = Validator::make(
                $data,
                [
                    'idEvento' => 'required|Int',
                    'idInscricao' => 'required|Int',
                ],
                [
                    'idEvento' => 'Informe o idEvento',
                    'idInscription' => 'Informe um numero de inscricao',
                ]
            );

            if ($validacao->fails()) {
                return Helpers::errorResponse($validacao->errors(), 500);
            }

            $inscricaoExiste = DB::select("select i.id, i.evento_id, p.nome, concat('https://sistemas.usb.org.br/uploads/sistemasusb/usuarios/',isnull(u.photo,'avatar-default.png')) foto, case when (r.descricao is null) then 'Não informado' else r.descricao end representacao, case when (pr.descricao is null) then 'Não informado' else pr.descricao end plenario, u.hash, case when (ore.descricao is null) then 'Não informado' else ore.descricao end organizadora, f.descricao funcao from inscricoes i
                                                inner join pessoas p on p.id = i.pessoa_id
                                                left JOIN organizadora_regioes ore ON ore.evento_id = i.evento_id  and
                                                                                            ore.id = i.organizadora_regiao_id
                                                left JOIN funcoes AS f ON f.id = i.funcao_id
                                                left join ERPUSB..Users u on u.UsersId = p.usuario_id
                                                left join representacoes r on r.id = i.representacao_id
                                                left join plenario_regioes pr on pr.id = i.plenario_regiao_id
                                                where i.id = ? and i.evento_id = ?", [$data['idInscricao'], $data['idEvento']]);

            if (count($inscricaoExiste) === 0) {
                return $this->retornaInscricao(0, "Não Encontrado", $foto, "Matricula não encontrada", $data['idInscricao']);
            }

            $foto = $inscricaoExiste[0]->foto;

            DB::update("update observacao_membros set ativo = 0 where evento_id = ?", [$data['idEvento']]);

            DB::insert("insert into observacao_membros (evento_id, inscricao_id, ativo, created_at, updated_at) values (?,?,?,getdate(),getdate())", [$data['idEvento'], $data['idInscricao'], 1]);

            $apiResp = $this->buscaImgApiERPUSB($inscricaoExiste[0]->hash);

            if (!empty($apiResp)) {
                $foto = $apiResp['body']['url'];
                //$evento->foto_pessoa_nome = $apiResp['body']['name'];
            }

            // Get the database client
            $database = app('firebase.database');

            // Get the reference to the data
            $reference = $database->getReference(env('APP_ENV') . '/observacao_painel/' . $data['idEvento']);

            // Update the data
            $reference->update(['Foto' => $foto, 'Nome' => $inscricaoExiste[0]->nome, 'Representacao' => $inscricaoExiste[0]->representacao, 'Plenario' => $inscricaoExiste[0]->plenario, 'Organizadora' => $inscricaoExiste[0]->organizadora, 'Funcao' => $inscricaoExiste[0]->funcao]);

            return $this->retornaInscricao(1, $inscricaoExiste[0]->nome, $foto, "Registrado com sucesso.", $data['idInscricao']);
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function limpapainel($eventoId)
    {
        try {
            // Get the database client
            $database = app('firebase.database');

            // Get the reference to the data
            $reference = $database->getReference(env('APP_ENV') . '/observacao_painel/' . $eventoId);

            // Remove the data
            $reference->remove();
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function atualizapainelorganizadora($eventoId)
    {
        //dispatch(new firebasePainelOrganizadora());
        $organizadora = DB::select("select ore.id as regiao_id,
                                                ore.evento_id,
                                                ore.descricao as regiao_organizadora,
                                                ore.numero_representantes,
                                                (select count(om.id)
                                                from organizadora_membros om
                                                inner join inscricoes	i		on	i.id			= om.inscricao_id and
                                                                                i.evento_id		= e.id and
                                                                                i.organizadora_regiao_id = ore.id
                                                where om.evento_id = e.id

                                                ) as numero_escolhido,
                                                (    select count(distinct i.plenario_regiao_id)

                                                            from    eventos        e
                                                                inner join inscricoes    i        on i.evento_id        = e.id
                                                                inner join pessoas        p        on    p.id = i.pessoa_id
                                                                inner join organizadora_regioes ore2 on ore.id = i.organizadora_regiao_id  and ore2.id = ore.id

                                                            where    e.id = ore.evento_id

                                                            ) as qtd_nomeados

                                            from organizadora_regioes ore
                                            inner join eventos		e		on	e.id = ore.evento_id
                                            where e.id = ?", [$eventoId]);

                                            // Log::info($organizadora);
                                           // dd($organizadora);

        if(count($organizadora) > 0){

            // Get the database client
            $database = app('firebase.database');

            // $reference = $database->getReference(env('APP_ENV') .'/organizadora_painel/' . $org->evento_id . '/' . $cont );
                    // Update the data

            $cont = 0;
            $event_comp_id = $organizadora[0]->evento_id;
            foreach ($organizadora as $org) {
                    if($event_comp_id != $org->evento_id){
                        $event_comp_id = $org->evento_id;
                        $cont = 0;
                    }
                    // Get the reference to the data
                    //$reference = $database->getReference(env('APP_ENV') .'/organizadora_painel/' . $org->evento_id . '/' . $cont );

                    // Update the data
                    //$reference->update(['regiao_organizadora' => $org->regiao_organizadora, 'numero_representantes' => $org->numero_representantes, 'numero_escolhido' => $org->numero_escolhido, 'qtd_nomeados' => $org->qtd_nomeados, 'regiao_id'=> $org->regiao_id]);

                    $dataArray[] = [
                        'regiao_organizadora' => $org->regiao_organizadora,
                        'numero_representantes' => $org->numero_representantes,
                        'numero_escolhido' => $org->numero_escolhido,
                        'qtd_nomeados' => $org->qtd_nomeados,
                        'regiao_id' => $org->regiao_id
                    ];

                    $cont++;
            }

            $reference = $database->getReference(env('APP_ENV') .'/organizadora_painel/');

                    // Update the data
            $reference->update([$eventoId => $dataArray]);


        }
        return "ok";
    }

    function insereQuadroEleitos($eventoId, $eleitoId){

        try{

            if($eleitoId == -1){
                $database = app('firebase.database');
                $reference = $database->getReference(env('APP_ENV') . '/quadro_eleitos_painel/' . $eventoId);
                $reference->remove();
                return Helpers::successResponse("Painel alterado com sucesso.");
            }

            $eleitos = DB::select("select e.id, e.nome, e.hash_foto,
                                                ( SELECT STUFF((
                                                    select ', ' + CONVERT(VARCHAR, af.descricao)
                                                        from eleito_assembleia_funcoes eaf
                                                        inner join assembleia_funcoes af on af.id = eaf.assembleia_funcao_id and af.ativo = 1
                                                        where eaf.eleito_id = e.id
                                                        order by af.ordem
                                                        FOR XML PATH('')
                                                    ), 1, 2, '')  ) Funcao,
                                                    '' urlimagem
                                                from eleitos e
                                                left join eleito_assembleia_funcoes eafp on eafp.eleito_id = e.id and eafp.principal = 1
                                                left join assembleia_funcoes afp on afp.id = eafp.assembleia_funcao_id and afp.ativo = 1
                                                where e.evento_id = ?
                                                and e.ativo = 1
                                                and (e.id = ? or ? = 0)
                                                order by afp.ordem", [$eventoId, $eleitoId, $eleitoId]);
            if(count($eleitos) > 0){
                $database = app('firebase.database');
                $reference = $database->getReference(env('APP_ENV') . '/quadro_eleitos_painel/' . $eventoId);
                $reference->remove();

                $cont = 0;
                foreach ($eleitos as $eleito) {

                    $apiResp = $this->buscaImgApi($eleito->hash_foto);
                    if (!empty($apiResp)) {
                        $eleito->urlimagem = $apiResp['body']['url'];
                    }

                    $reference = $database->getReference(env('APP_ENV') . '/quadro_eleitos_painel/' . $eventoId . '/' . $cont);
                    $reference->update(['nome' => $eleito->nome, 'funcao' => $eleito->Funcao, 'urlimagem' => $eleito->urlimagem]);

                    $cont++;
                }
            }

            return Helpers::successResponse("Painel alterado com sucesso.");


        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function sorteioGeralOrganizadora($idEvento, $distrito = 0) {

        $eventoAtivo = DB::select("select escolha_organizadora_tipo_id from eventos where id = ?", [$idEvento]);

        if(count($eventoAtivo) === 0){
            return Helpers::errorResponse("Evento não existe", 500);
        }

        if($eventoAtivo[0]->escolha_organizadora_tipo_id != 1){
            return Helpers::errorResponse("Evento não disponivel para sorteio geral", 500);
        }

        DB::delete("delete om from organizadora_membros om
                    inner join inscricoes i on i.id = om.inscricao_id
                    inner join plenario_regioes pr on pr.id = i.plenario_regiao_id
                    where om.evento_id = ?
                    and (pr.id = ? or ? = 0)", [$idEvento, $distrito, $distrito]);

        $buscaCandidato = DB::select("select  i.id,
                                                        ps.nome,
                                                        pr.id id_distrito,
                                                        pr.descricao distrito,
                                                        ore.id idRegiao,
                                                        ore.descricao regiao

                                                from    inscricoes i
                                                        inner join pessoas ps           on  ps.id = i.pessoa_id
                                                        inner join plenario_regioes pr  on  pr.id       = i.plenario_regiao_id and
                                                                                            pr.ativo    = 1
                                                        inner join organizadora_regioes ore on ore.id = i.organizadora_regiao_id

                                                where   i.evento_id = ? and
                                                        (pr.id = ? or ? = 0)
                                                        and i.cancelada = 0
                                                        AND exists (select p.id from presencas  p
                                                                    where   p.evento_id         = i.evento_id and
                                                                            p.tipo              = 'E' and
                                                                            p.inscricao_id      = i.id)

                                                order by
                                                        ore.descricao,
                                                        pr.descricao,
                                                        ps.nome",[$idEvento, $distrito, $distrito]);

        $arrayRegioes = [];
        $arrayListaRegioes = [];
        foreach($buscaCandidato as $candidato){
            if (!in_array($candidato->regiao . $candidato->distrito, $arrayRegioes)) {
                $arrayRegioes[] = $candidato->regiao . $candidato->distrito;
            }

            if (!in_array($candidato->regiao, $arrayListaRegioes)) {
                $arrayListaRegioes[$candidato->regiao] = 0;
            }
        }

        $database = app('firebase.database');

        $cont = 0;
        foreach($arrayRegioes as $regiaoAtual){

            $regiaoDesejada = $regiaoAtual;

            $eventosFiltrados = array_filter($buscaCandidato, function ($evento) use ($regiaoDesejada) {
                return $evento->regiao . $evento->distrito === $regiaoDesejada;
            });

            $elementoAleatorio = $this->buscarElementoAleatorio($eventosFiltrados);

            $arrayListaRegioes[$elementoAleatorio->regiao] = $arrayListaRegioes[$elementoAleatorio->regiao] + 1;

            DB::insert("insert into organizadora_membros (evento_id, inscricao_id, created_at, updated_at) values (?,?,GETDATE(),GETDATE())", [$idEvento, $elementoAleatorio->id]);

            $reference = $database->getReference(env('APP_ENV') . '/sorteio_geral/' . $idEvento . '/' . $cont );

            $reference->update(['distritoId' => $elementoAleatorio->id_distrito, 'total_regiao' => $arrayListaRegioes[$elementoAleatorio->regiao], 'regiao' => $elementoAleatorio->regiao, 'idRegiao' => $elementoAleatorio->idRegiao]);

            $cont++;

        }

        if($distrito !== 0){
            $pessoa = DB::select("select  p.nome,
                                                    u.email as email,
                                                    r.descricao as representacao,
                                                    pr.descricao as regiao_plenario

                                            from    organizadora_membros om
                                                    inner join inscricoes i         on i.evento_id = om.evento_id and i.id = om.inscricao_id
                                                    inner join pessoas p            on p.id = i.pessoa_id
                                                    inner join erpusb.dbo.users u   on u.UsersId = p.usuario_id
                                                    inner join representacoes r     on r.id  = i.representacao_id
                                                    inner join plenario_regioes pr  on pr.id = i.plenario_regiao_id

                                            where       om.evento_id            = ?
                                                    and i.plenario_regiao_id    = ?", [$idEvento, $distrito]);
            return Helpers::successResponse($pessoa[0]);
        }

        return Helpers::successResponse("Sorteio gerado com sucesso.");

    }

    public function buscarElementoAleatorio(array $dados)
    {
        // Obtém um elemento aleatório do array
        $chaves = array_keys($dados);
        $chaveAleatoria = array_rand($chaves);
        $elementoAleatorio = $dados[$chaves[$chaveAleatoria]];

        return $elementoAleatorio;
    }
}
