<?php

namespace App\Http\Controllers;

use App\Helpers\Helpers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class ConfigController extends Controller
{
    //
    public function versao(){
        try{

            $versao = DB::select('select versao_android, versao_ios from globais');

            $tipo = [
                "versao_android" => "intVal",
                "versao_ios" => "intVal"
            ];
                        
            $resposta = Helpers::convertTypes($versao, $tipo);

            return Helpers::successResponse($resposta[0]);

        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function add_token(Request $request){
        try{

            $content = $request->getContent();
            $data = json_decode($content, true);
            

            $idUser = Helpers::pegaIdPessoa($request);

            $validacao = Validator::make($data,[
                'token'     => 'required',
            ],
            [
                'token'     => 'Informe um token',
            ]);

            if($validacao->fails()){
                return Helpers::errorResponse($validacao->errors(), 500);
            }

            $result = DB::select('select * from firebases where pessoa_id = ? and firebase_id = ?', [$idUser, $data['token']]);

            if(count($result) > 0){
                return Helpers::successResponse('Token Presente no Sitema.');
            }

            DB::insert('insert into firebases (pessoa_id, firebase_id, created_at, updated_at) values (?, ?, GETDATE(), GETDATE())',[$idUser, $data['token']]);

            return Helpers::successResponse('Token Incluido Com Sucesso.');
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function remove_token(Request $request){
        try{

            $content = $request->getContent();
            $data = json_decode($content, true);

            $validacao = Validator::make($data,[
                'token'     => 'required',
            ],
            [
                'token'     => 'Informe um token',
            ]);

            if($validacao->fails()){
                return Helpers::errorResponse($validacao->errors(), 500);
            }

            DB::insert('delete from firebases where firebase_id = ?',[$data['token']]);

            return Helpers::successResponse('Token Excluido Com Sucesso.');
        } catch (\Exception $e) {
            return Helpers::errorResponse($e->getMessage(), 500);
        }
    }

    function portariaiap($ra){
        // Get the database client
        $database = app('firebase.database');

        // Get the reference to the data
        $reference = $database->getReference(env('APP_ENV') . '/portaria_iap/');

        // Update the data
        $reference->update(['ra' => $ra]);

        return 'ok';
    }

}
